﻿using System;
using System.Linq;
using System.Web;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessManager.EFR;
using System.Web.Security.AntiXss;
using System.Collections.Generic;

public partial class ReferralContactLog : BasePage 
{
    private static IReadOnlyList<string> _navigationSources = new List<string>
    {
        "/ReferralContactLogs.aspx",
        "/PatientWorkflows.aspx"
    };

    private readonly ContactLogManager _manager;
    private readonly UserAccountManager _user;

    public ReferralContactLog()
    {
        _manager = new ContactLogManager();
        _user = (UserAccountManager)HttpContext.Current.User;

        NavigationSources = _navigationSources;
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            SetReferringPage();

            BreadCrumbLabel.Text = AntiXssEncoder.HtmlEncode(BreadCrumbLabel.Text + Request.QueryString["referralId"].ToString(), false);
        }
    }

    protected void EFRReferralChatLog_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        int referralId;
        bool success = int.TryParse(Request.QueryString["referralId"], out referralId);
       
        if (e.CommandName.Equals("Details"))
        {
            HiddenField hiddenID = (HiddenField)e.Item.FindControl("ContactIDField");
            string id = hiddenID.Value;

            Response.Redirect("ReferralContact.aspx?referralId={0}&contactId={1}", referralId, id);


        }
        else if (e.CommandName.Equals("Add"))
        {
            Response.Redirect("ReferralContact.aspx?referralId={0}", referralId);

        }
        else if (e.CommandName.Equals("DeleteContact"))
        {
            HiddenField hiddenID = (HiddenField)e.Item.FindControl("ContactIDField");
            string id = hiddenID.Value;

            CONTACT_LOG contact = _manager.SelectByContactID(int.Parse(id));
            //CONTACT_LOG contact = e.Item.DataItem as CONTACT_LOG;
            contact.SetAsDeleteOnSubmit();

            _manager.Update(contact);

            EFRReferralChatLog.DataBind(); 

        }

    }

    protected void EFRReferralChatLog_DataBound(object source, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem
                    || e.Item.ItemType == ListItemType.SelectedItem)
        {
            var cntctlgDt = e.Item.DataItem as ContactLogManager.ContactLog;
            if (cntctlgDt != null)
            {
                var reason = cntctlgDt.ContactReason;
                if (reason != null)
                {
                    if (reason.Equals(EFRSharedConstant.ContactLogReasonPrinted)
                    || reason.Equals(EFRSharedConstant.ContactLogReasonUnaccepted))
                    {
                        Button edit = e.Item.FindControl("SelectButton") as Button;
                        if (edit != null)
                            edit.Enabled = false;

                        Button del = e.Item.FindControl("DeleteButton") as Button;

                        if (del != null)
                            del.Enabled = false;
                    }
                }                
            }            
        }
    }

    protected void CancelButton_OnClick(object sender, EventArgs e)
    {
        RedirectToReferringPage();
    }

    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "All Contacts";
    }

    public override string AppObjectCode()
    {
        return "EFR_CONTACTLOGS";
    }

    public bool EnableButtton()
    {
        //Only TEFSC Coordinator can delete a contact episode.
        return _user.GetRoles().Contains((int)RoleCode.EFR_TEFSC_COORDINATOR);
    }
}
